-- $Header: /devl/xcs/repo/env/Databases/ip/src2/L/xbip_dsp48_macro_v2_0/simulation/bip_dsp48_macro_pkg_v2_0.vhd,v 1.3 2009/12/04 11:46:21 akennedy Exp $
-------------------------------------------------------------------------------
--  Copyright(C) 2008 by Xilinx, Inc. All rights reserved.
--  This text/file contains proprietary, confidential
--  information of Xilinx, Inc., is distributed under license
--  from Xilinx, Inc., and may be used, copied and/or
--  disclosed only pursuant to the terms of a valid license
--  agreement with Xilinx, Inc.  Xilinx hereby grants you
--  a license to use this text/file solely for design, simulation,
--  implementation and creation of design files limited
--  to Xilinx devices or technologies. Use with non-Xilinx
--  devices or technologies is expressly prohibited and
--  immediately terminates your license unless covered by
--  a separate agreement.
--
--  Xilinx is providing this design, code, or information
--  "as is" solely for use in developing programs and
--  solutions for Xilinx devices.  By providing this design,
--  code, or information as one possible implementation of
--  this feature, application or standard, Xilinx is making no
--  representation that this implementation is free from any
--  claims of infringement.  You are responsible for
--  obtaining any rights you may require for your implementation.
--  Xilinx expressly disclaims any warranty whatsoever with
--  respect to the adequacy of the implementation, including
--  but not limited to any warranties or representations that this
--  implementation is free from claims of infringement, implied
--  warranties of merchantability or fitness for a particular
--  purpose.
--
--  Xilinx products are not intended for use in life support
--  appliances, devices, or systems. Use in such applications are
--  expressly prohibited.
--
--  This copyright and support notice must be retained as part
--  of this text at all times. (c) Copyright 2008 Xilinx, Inc.
--  All rights reserved.
-------------------------------------------------------------------------------

-- ### WARNING!!!  DO NOT EDIT THIS FILE BY HAND!  USE cp_to_sim.sh IN hdl/ INSTEAD! ###

library ieee;
use ieee.std_logic_1164.all;
--use ieee.std_logic_arith.conv_std_logic_vector;
use ieee.numeric_std.all;

library xilinxcorelib;
use xilinxcorelib.bip_usecase_utils_pkg_v2_0.all;
use xilinxcorelib.bip_utils_pkg_v2_0.all;

-------------------------------------------------------------------------------
-- Designer note!!
-- This file is for the top level component declaration and any types and functions
-- which calling cores may require. Internal functions, types and component declarations
-- should be in the dsp48_addsub_hdl_pkg file.
-------------------------------------------------------------------------------

package bip_dsp48_macro_pkg_v2_0 is

  constant ci_num_opmodes : integer := 42;
  
  function fn_dsp48_macro_v2_0_check_generics (  --deliberately no defaults.
    P_VERBOSITY       : integer;
    P_MODEL_TYPE      : integer;
    P_XDEVICEFAMILY   : string ;
    P_HAS_CE          : integer;
    P_HAS_SCLR        : integer;
    P_HAS_CARRYCASCIN : integer;
    P_HAS_ACIN        : integer;
    P_HAS_BCIN        : integer;
    P_HAS_A           : integer;
    P_HAS_B           : integer;
    P_HAS_D           : integer;
    P_HAS_CONCAT      : integer;
    P_A_WIDTH         : integer;
    P_B_WIDTH         : integer;
    P_C_WIDTH         : integer;
    P_D_WIDTH         : integer;
    P_CONCAT_WIDTH    : integer;
    -- P_P_WIDTH         : integer;
    P_SEL_WIDTH       : integer;
    P_LATENCY         : integer;
    P_OPMODES         : string;
    P_REG_CONFIG      : string
    ) return integer;


  --core_if on component xbip_dsp48_macro
  component xbip_dsp48_macro
    generic (
      C_VERBOSITY        : integer := 0  ;                                 -- 0 = Errors 1 = +Warnings, 2 = +Notes and tips
      C_MODEL_TYPE       : integer := 0  ;                                 -- 0 = synth, 1 = RTL
      C_XDEVICEFAMILY    : string  := "virtex5";
      C_HAS_CE           : integer := 0;
      C_HAS_SCLR         : integer := 0;
      C_HAS_CARRYCASCIN  : integer := 0;
      C_HAS_CARRYIN      : integer := 0;
      C_HAS_ACIN         : integer := 0;
      C_HAS_BCIN         : integer := 0;
      C_HAS_PCIN         : integer := 0;
      C_HAS_A            : integer := 1;
      C_HAS_B            : integer := 1;
      C_HAS_D            : integer := 1;
      C_HAS_CONCAT       : integer := 0;
      C_HAS_C            : integer := 0;
      C_A_WIDTH          : integer := ci_dsp48_b_width ;                   -- can't use a function here.
      C_B_WIDTH          : integer := ci_dsp48_b_width;
      C_C_WIDTH          : integer := ci_dsp48_c_width;
      C_D_WIDTH          : integer := 0 ;                                  -- can't use a function here.
      C_CONCAT_WIDTH     : integer := 0;
      C_P_MSB            : integer := ci_dsp48_p_width-1  ;
      C_P_LSB            : integer := 0;
      C_SEL_WIDTH        : integer := 5;
      C_HAS_ACOUT        : integer := 0;
      C_HAS_BCOUT        : integer := 0;
      C_HAS_CARRYCASCOUT : integer := 0;
      C_HAS_CARRYOUT     : integer := 0;
      C_HAS_PCOUT        : integer := 0;
      C_CONSTANT_1       : integer := 1;
      C_LATENCY          : integer := -1;
      C_OPMODES          : string  := "";
      C_REG_CONFIG       : string  := "00000000000000000000000000000000";
      C_TEST_CORE        : integer := 0                                    --  0 = normal releas core behavour 1 = generate a test core
      );
    port (
      CLK          : in  std_logic                                                           := '1';
      CE           : in  std_logic                                                           := '1';
      SCLR         : in  std_logic                                                           := '0';
      SEL          : in  std_logic_vector(C_SEL_WIDTH+boolean'pos(C_SEL_WIDTH=0)-1 downto 0) := (others => '0');  -- Guard against -1 to 0 when C_SEL_WIDTH=0
      CARRYCASCIN  : in  std_logic                                                           := '0';
      CARRYIN      : in  std_logic                                                           := '0';
      PCIN         : in  std_logic_vector(ci_dsp48_p_width-1 downto 0)                       := (others => '0');
      ACIN         : in  std_logic_vector(fn_dsp48_a_width(C_XDEVICEFAMILY)-1 downto 0)      := (others => '0');
      BCIN         : in  std_logic_vector(ci_dsp48_b_width-1 downto 0)                       := (others => '0');
      A            : in  std_logic_vector(C_A_WIDTH-1 downto 0)                              := (others => '0');
      B            : in  std_logic_vector(C_B_WIDTH-1 downto 0)                              := (others => '0');
      C            : in  std_logic_vector(C_C_WIDTH-1 downto 0)                              := (others => '0');
      D            : in  std_logic_vector(C_D_WIDTH-1 downto 0)                              := (others => '0');
      CONCAT       : in  std_logic_vector(C_CONCAT_WIDTH-1 downto 0)                         := (others => '0');
      ACOUT        : out std_logic_vector(fn_dsp48_a_width(C_XDEVICEFAMILY)-1 downto 0)      := (others => '0');
      BCOUT        : out std_logic_vector(ci_dsp48_b_width-1 downto 0)                       := (others => '0');
      CARRYOUT     : out std_logic                                                           := '0';
      CARRYCASCOUT : out std_logic                                                           := '0';
      PCOUT        : out std_logic_vector(ci_dsp48_p_width-1 downto 0)                       := (others => '0');
      P            : out std_logic_vector(C_P_MSB-C_P_LSB downto 0)                          := (others => '0')
      );
  --core_if off
  end component;

  --core_if on component bip_dsp48_macro_synth
  component bip_dsp48_macro_synth
    generic (
      C_VERBOSITY        : integer := 0  ;                                 -- 0 = Errors 1 = +Warnings, 2 = +Notes and tips
      C_MODEL_TYPE       : integer := 0  ;                                 -- 0 = synth, 1 = RTL
      C_XDEVICEFAMILY    : string  := "virtex5";
      C_HAS_CE           : integer := 0;
      C_HAS_SCLR         : integer := 0;
      C_HAS_CARRYCASCIN  : integer := 0;
      C_HAS_CARRYIN      : integer := 0;
      C_HAS_ACIN         : integer := 0;
      C_HAS_BCIN         : integer := 0;
      C_HAS_PCIN         : integer := 0;
      C_HAS_A            : integer := 1;
      C_HAS_B            : integer := 1;
      C_HAS_D            : integer := 1;
      C_HAS_CONCAT       : integer := 0;
      C_HAS_C            : integer := 0;
      C_A_WIDTH          : integer := ci_dsp48_b_width ;                   -- can't use a function here.
      C_B_WIDTH          : integer := ci_dsp48_b_width;
      C_C_WIDTH          : integer := ci_dsp48_c_width;
      C_D_WIDTH          : integer := 0 ;                                  -- can't use a function here.
      C_CONCAT_WIDTH     : integer := 0;
      C_P_MSB            : integer := ci_dsp48_p_width-1  ;
      C_P_LSB            : integer := 0;
      C_SEL_WIDTH        : integer := 5;
      C_HAS_ACOUT        : integer := 0;
      C_HAS_BCOUT        : integer := 0;
      C_HAS_CARRYCASCOUT : integer := 0;
      C_HAS_CARRYOUT     : integer := 0;
      C_HAS_PCOUT        : integer := 0;
      C_CONSTANT_1       : integer := 1;
      C_LATENCY          : integer := -1;
      C_OPMODES          : string  := "";
      C_REG_CONFIG       : string  := "00000000000000000000000000000000";
      C_TEST_CORE        : integer := 0                                    --  0 = normal releas core behavour 1 = generate a test core
      );
    port (
      CLK          : in  std_logic                                                           := '1';
      CE           : in  std_logic                                                           := '1';
      SCLR         : in  std_logic                                                           := '0';
      SEL          : in  std_logic_vector(C_SEL_WIDTH+boolean'pos(C_SEL_WIDTH=0)-1 downto 0) := (others => '0');  -- Guard against -1 to 0 when C_SEL_WIDTH=0
      CARRYCASCIN  : in  std_logic                                                           := '0';
      CARRYIN      : in  std_logic                                                           := '0';
      PCIN         : in  std_logic_vector(ci_dsp48_p_width-1 downto 0)                       := (others => '0');
      ACIN         : in  std_logic_vector(fn_dsp48_a_width(C_XDEVICEFAMILY)-1 downto 0)      := (others => '0');
      BCIN         : in  std_logic_vector(ci_dsp48_b_width-1 downto 0)                       := (others => '0');
      A            : in  std_logic_vector(C_A_WIDTH-1 downto 0)                              := (others => '0');
      B            : in  std_logic_vector(C_B_WIDTH-1 downto 0)                              := (others => '0');
      C            : in  std_logic_vector(C_C_WIDTH-1 downto 0)                              := (others => '0');
      D            : in  std_logic_vector(C_D_WIDTH-1 downto 0)                              := (others => '0');
      CONCAT       : in  std_logic_vector(C_CONCAT_WIDTH-1 downto 0)                         := (others => '0');
      ACOUT        : out std_logic_vector(fn_dsp48_a_width(C_XDEVICEFAMILY)-1 downto 0)      := (others => '0');
      BCOUT        : out std_logic_vector(ci_dsp48_b_width-1 downto 0)                       := (others => '0');
      CARRYOUT     : out std_logic                                                           := '0';
      CARRYCASCOUT : out std_logic                                                           := '0';
      PCOUT        : out std_logic_vector(ci_dsp48_p_width-1 downto 0)                       := (others => '0');
      P            : out std_logic_vector(C_P_MSB-C_P_LSB downto 0)                          := (others => '0')
      );
  --core_if off
  end component;

  --core_if on component bip_dsp48_macro_rtl
  component bip_dsp48_macro_rtl
    generic (
      C_VERBOSITY        : integer := 0  ;                                 -- 0 = Errors 1 = +Warnings, 2 = +Notes and tips
      C_MODEL_TYPE       : integer := 0  ;                                 -- 0 = synth, 1 = RTL
      C_XDEVICEFAMILY    : string  := "virtex5";
      C_HAS_CE           : integer := 0;
      C_HAS_SCLR         : integer := 0;
      C_HAS_CARRYCASCIN  : integer := 0;
      C_HAS_CARRYIN      : integer := 0;
      C_HAS_ACIN         : integer := 0;
      C_HAS_BCIN         : integer := 0;
      C_HAS_PCIN         : integer := 0;
      C_HAS_A            : integer := 1;
      C_HAS_B            : integer := 1;
      C_HAS_D            : integer := 1;
      C_HAS_CONCAT       : integer := 0;
      C_HAS_C            : integer := 0;
      C_A_WIDTH          : integer := ci_dsp48_b_width ;                   -- can't use a function here.
      C_B_WIDTH          : integer := ci_dsp48_b_width;
      C_C_WIDTH          : integer := ci_dsp48_c_width;
      C_D_WIDTH          : integer := 0 ;                                  -- can't use a function here.
      C_CONCAT_WIDTH     : integer := 0;
      C_P_MSB            : integer := ci_dsp48_p_width-1  ;
      C_P_LSB            : integer := 0;
      C_SEL_WIDTH        : integer := 5;
      C_HAS_ACOUT        : integer := 0;
      C_HAS_BCOUT        : integer := 0;
      C_HAS_CARRYCASCOUT : integer := 0;
      C_HAS_CARRYOUT     : integer := 0;
      C_HAS_PCOUT        : integer := 0;
      C_CONSTANT_1       : integer := 1;
      C_LATENCY          : integer := -1;
      C_OPMODES          : string  := "";
      C_REG_CONFIG       : string  := "00000000000000000000000000000000";
      C_TEST_CORE        : integer := 0                                    --  0 = normal releas core behavour 1 = generate a test core
      );
    port (
      CLK          : in  std_logic                                                           := '1';
      CE           : in  std_logic                                                           := '1';
      SCLR         : in  std_logic                                                           := '0';
      SEL          : in  std_logic_vector(C_SEL_WIDTH+boolean'pos(C_SEL_WIDTH=0)-1 downto 0) := (others => '0');  -- Guard against -1 to 0 when C_SEL_WIDTH=0
      CARRYCASCIN  : in  std_logic                                                           := '0';
      CARRYIN      : in  std_logic                                                           := '0';
      PCIN         : in  std_logic_vector(ci_dsp48_p_width-1 downto 0)                       := (others => '0');
      ACIN         : in  std_logic_vector(fn_dsp48_a_width(C_XDEVICEFAMILY)-1 downto 0)      := (others => '0');
      BCIN         : in  std_logic_vector(ci_dsp48_b_width-1 downto 0)                       := (others => '0');
      A            : in  std_logic_vector(C_A_WIDTH-1 downto 0)                              := (others => '0');
      B            : in  std_logic_vector(C_B_WIDTH-1 downto 0)                              := (others => '0');
      C            : in  std_logic_vector(C_C_WIDTH-1 downto 0)                              := (others => '0');
      D            : in  std_logic_vector(C_D_WIDTH-1 downto 0)                              := (others => '0');
      CONCAT       : in  std_logic_vector(C_CONCAT_WIDTH-1 downto 0)                         := (others => '0');
      ACOUT        : out std_logic_vector(fn_dsp48_a_width(C_XDEVICEFAMILY)-1 downto 0)      := (others => '0');
      BCOUT        : out std_logic_vector(ci_dsp48_b_width-1 downto 0)                       := (others => '0');
      CARRYOUT     : out std_logic                                                           := '0';
      CARRYCASCOUT : out std_logic                                                           := '0';
      PCOUT        : out std_logic_vector(ci_dsp48_p_width-1 downto 0)                       := (others => '0');
      P            : out std_logic_vector(C_P_MSB-C_P_LSB downto 0)                          := (others => '0')
      );
  --core_if off
  end component;

--  type t_macro_type is (e_invalid, e_adder_only, e_mult_only, e_mult_and_add);
  type t_macro_config is record
                           use_cascade : boolean;
                           use_mult    : boolean;
                           use_premux  : boolean;
                           use_round   : boolean;
                           num_opmodes : integer;
                         end record;

  function fn_get_macro_config (
    pOPMODE : string)
    return t_macro_config;
  
  constant ci_max_latency     : integer := 6;
  constant ci_num_registers   : integer := 32;
  type t_dsp48_macro_pipe is array (0 to ci_num_registers) of integer;
  type t_dsp48_macro_latency is record
                                 used : integer;
                                 pipe : t_dsp48_macro_pipe;
                                 --reg_config : string(1 to ci_num_registers);
                                 --Works better in Rabassa as integer array
                                 --  keep a seperate element for feedback as some values may be different for informational purposes. 
                                 reg_config : t_dsp48_macro_pipe;
                               end record;

  constant ci_a1       : integer := 1;
  constant ci_b1       : integer := 2;
  constant ci_c1       : integer := 3;
  constant ci_d1       : integer := 4;
  constant ci_carryin1 : integer := 5;
  constant ci_op1      : integer := 6;

  constant ci_a2       : integer := 7;
  constant ci_b2       : integer := 8;
  constant ci_c2       : integer := 9;
  constant ci_d2       : integer := 10;
  constant ci_carryin2 : integer := 11;
  constant ci_op2      : integer := 12;

  constant ci_a3       : integer := 13;
  constant ci_b3       : integer := 14;
  constant ci_c3       : integer := 15;
  constant ci_d3       : integer := 16;
  constant ci_carryin3 : integer := 17;
  constant ci_op3      : integer := 18;

  constant ci_a4       : integer := 19;
  constant ci_b4       : integer := 20;
  constant ci_c4       : integer := 21;
  constant ci_carryin4 : integer := 22;
  constant ci_concat4  : integer := 23;
  constant ci_op4      : integer := 24;

  constant ci_c5       : integer := 25;
  constant ci_m5       : integer := 26;
  constant ci_op5      : integer := 27;
  constant ci_carryin5 : integer := 28;
  constant ci_concat5  : integer := 29;

  constant ci_p6        : integer := 30;
  constant ci_carryin6  : integer := 31;
  constant ci_carryout6 : integer := 32;

  --Fields of OPMODE, defined in PDD
  constant ci_opmode_width: integer := 19;
  
  constant ci_opfield_abmux    : integer := 0;
  subtype ti_opfield_preadd     is integer range 5 downto 1;
  constant ci_opfield_cmux     : integer := 6;
  subtype ti_opfield_xmux     is integer range 8 downto 7;
  subtype ti_opfield_ymux     is integer range 10 downto 9;
  subtype ti_opfield_zmux     is integer range 13 downto 11;
  constant ci_opfield_subtract : integer := 14;
  constant ci_opfield_carryin  : integer := 15;
  subtype ti_opfield_carrysel is integer range 18 downto 16;
  
  --For Rabassa conversion
  constant ci_opfield_xmux_0  : integer := 7;
  constant ci_opfield_xmux_1  : integer := 8;
  
--path
  
  function fn_dsp48_macro_v2_0_latency (
      P_VERBOSITY       : integer;                                             -- 0 = Errors 1 = +Warnings, 2 = +Notes and tips
      P_MODEL_TYPE      : integer;                                             -- 0 = synth, 1 = RTL
      P_XDEVICEFAMILY   : string ;
      P_HAS_CE          : integer;
      P_HAS_SCLR        : integer;
      P_HAS_CARRYCASCIN : integer;
      P_HAS_CARRYIN     : integer;
      P_HAS_ACIN        : integer;
      P_HAS_BCIN        : integer;
      P_HAS_A           : integer;
      P_HAS_B           : integer;
      P_HAS_D           : integer;
      P_HAS_CONCAT      : integer;
      P_A_WIDTH         : integer;                              -- can't use a function here.
      P_B_WIDTH         : integer; 
      P_C_WIDTH         : integer; 
      P_D_WIDTH         : integer;                                             -- can't use a function here.
      P_CONCAT_WIDTH    : integer;
      -- P_P_WIDTH         : integer;
      P_SEL_WIDTH       : integer;
      P_LATENCY         : integer;
      P_OPMODES         : string;
      P_REG_CONFIG      : string
      )
    return t_dsp48_macro_latency;

  -- function fn_get_round_const (
    -- p_p_width : integer
    -- )
    -- return std_logic_vector;
  function fn_get_round_const (
    p_p_lsb : integer
    )
    return std_logic_vector;

  type t_opmode_type is record
                          disassembled : string(1 to 50);
                        end record;
  function fn_interpret_opmode (
    opmode : std_logic_vector(ci_opmode_width-1 downto 0)
    )
    return t_opmode_type;
  
  function fn_select_int ( in1, in2 : integer; sel:boolean ) return integer;
  
end package bip_dsp48_macro_pkg_v2_0;

package body bip_dsp48_macro_pkg_v2_0 is

  function fn_dsp48_macro_v2_0_check_generics (
    P_VERBOSITY       : integer;
    P_MODEL_TYPE      : integer;
    P_XDEVICEFAMILY   : string ;
    P_HAS_CE          : integer;
    P_HAS_SCLR        : integer;
    P_HAS_CARRYCASCIN : integer;
    P_HAS_ACIN        : integer;
    P_HAS_BCIN        : integer;
    P_HAS_A           : integer;
    P_HAS_B           : integer;
    P_HAS_D           : integer;
    P_HAS_CONCAT      : integer;
    P_A_WIDTH         : integer;
    P_B_WIDTH         : integer;
    P_C_WIDTH         : integer;
    P_D_WIDTH         : integer;
    P_CONCAT_WIDTH    : integer;
    -- P_P_WIDTH         : integer;
    P_SEL_WIDTH       : integer;
    P_LATENCY         : integer;
    P_OPMODES         : string ;
    P_REG_CONFIG      : string
    ) return integer is
  begin
    assert P_HAS_CE = 0 or P_HAS_CE = 1
      report "ERROR: xbip_dsp48_macro: C_HAS_CE out of range. Got "&integer'image(P_HAS_CE)
      severity error;
    assert P_HAS_SCLR = 0 or P_HAS_SCLR = 1
      report "ERROR: xbip_dsp48_macro: C_HAS_SCLR out of range. Got "&integer'image(P_HAS_SCLR)
      severity error;
    assert (P_CONCAT_WIDTH>=0 and P_CONCAT_WIDTH <=48)
      report "ERROR: xbip_dsp48_macro: C_CONCAT_WIDTH out of range. Got "&integer'image(P_CONCAT_WIDTH)
      severity error;
    if P_HAS_A = 1 then
      assert (P_A_WIDTH>=0 and P_A_WIDTH <=fn_dsp48_a_width(P_XDEVICEFAMILY))
        report "ERROR: xbip_dsp48_macro: C_A_WIDTH out of range. Got "&integer'image(P_A_WIDTH)
        severity error;
    end if;
    if P_HAS_B = 1 then
    assert (P_B_WIDTH>0 and P_B_WIDTH <=ci_dsp48_b_width)
      report "ERROR: xbip_dsp48_macro: C_B_WIDTH out of range. Got "&integer'image(P_B_WIDTH)
      severity error;
    end if;
    assert (P_C_WIDTH>0 and P_C_WIDTH <=ci_dsp48_c_width)
      report "ERROR: xbip_dsp48_macro: C_C_WIDTH out of range. Got "&integer'image(P_C_WIDTH)
      severity error;
    if P_HAS_D = 1 then
      assert (P_D_WIDTH>0 and P_D_WIDTH <=fn_dsp48_d_width(P_XDEVICEFAMILY))
        report "ERROR: xbip_dsp48_macro: C_D_WIDTH out of range. Got "&integer'image(P_D_WIDTH)
        severity error;
      assert supports_dsp48a(P_XDEVICEFAMILY)>0 or supports_dsp48e1(P_XDEVICEFAMILY)>0
        report "ERROR: xbip_dsp48_macro : this family does not support the D port"
        severity error;
    end if;
    assert P_HAS_ACIN = 0 or P_HAS_ACIN = 1
      report "ERROR: xbip_dsp48_macro: C_HAS_ACIN out of range"
      severity error;
    assert P_HAS_BCIN = 0 or P_HAS_BCIN = 1
      report "ERROR: xbip_dsp48_macro: C_HAS_BCIN out of range"
      severity error;
    assert P_HAS_CARRYCASCIN = 0 or P_HAS_CARRYCASCIN = 1
      report "ERROR: xbip_dsp48_macro: C_HAS_CARRYCASCIN out of range"
      severity error;
    assert P_HAS_CARRYCASCIN = 0 or supports_dsp48a(P_XDEVICEFAMILY)>0 or supports_dsp48e(P_XDEVICEFAMILY)>0
      report "ERROR: xbip_dsp48_macro: C_HAS_CARRYCASCIN is unavailable for this family"
      severity error;
    assert (P_SEL_WIDTH >= 0) and (P_SEL_WIDTH <= 6)
      report "ERROR : xbip_dsp48_macro: C_SEL_WIDTH must be between 0 and 6"
      severity error;

    --Checks to add
    --1. Opmodes which use P must have Preg (ci_p6) enabled.
    return 0;
  end function fn_dsp48_macro_v2_0_check_generics;

  function fn_dsp48_macro_v2_0_latency (
    P_VERBOSITY       : integer;
    P_MODEL_TYPE      : integer;
    P_XDEVICEFAMILY   : string ;
    P_HAS_CE          : integer;
    P_HAS_SCLR        : integer;
    P_HAS_CARRYCASCIN : integer;
    P_HAS_CARRYIN     : integer;
    P_HAS_ACIN        : integer;
    P_HAS_BCIN        : integer;
    P_HAS_A           : integer;
    P_HAS_B           : integer;
    P_HAS_D           : integer;
    P_HAS_CONCAT      : integer;
    P_A_WIDTH         : integer;
    P_B_WIDTH         : integer;
    P_C_WIDTH         : integer;
    P_D_WIDTH         : integer;
    P_CONCAT_WIDTH    : integer;
    -- P_P_WIDTH         : integer;
    P_SEL_WIDTH       : integer;
    P_LATENCY         : integer;
    P_OPMODES         : string ;
    P_REG_CONFIG      : string
    )
    return t_dsp48_macro_latency is
    variable ret_val : t_dsp48_macro_latency;
    variable v_latency_left : integer;
    variable v_enable_tier : std_logic_vector(5 downto 0); -- Rabassa had trouble with 7 downto 1
    variable v_macro_config : t_macro_config;
    variable v_reg_config : string(1 to ci_num_registers);
  begin
    v_macro_config := fn_get_macro_config(P_OPMODES);
    
    ---------------------------------------------------------------------------
    -- Latency is overloaded as follows:
    -- A) -1 means 'optimally pipelined' - in this case square latency
    -- B) 0 to 6 means pipe tiers (from P backwards)
    -- C) 64 to 128 is interpreted as a bit vector (ignoring the top bit which is
    -- just a flag). Hence each bit from 6 downto 1 enables a tier of registers.
    -- D) Finally, full expert mode is 128. In this case, the REG_CONFIG array
    -- is read to enable registers individually.
    ---------------------------------------------------------------------------
    --initialise all latency stages to 0.
    for i in 0 to ci_num_registers loop
      ret_val.pipe(i) := 0;
    end loop;  -- i
    ret_val.used := 0;

    -- gui trans_off
    v_enable_tier := (others => '0');
    -- gui trans_on
    -- gui insert_on
    -- v_enable_tier := int_to_slv(0, 6);
    -- gui insert_off
        
    --v_latency_left only has meaning in the tiered model of latency
    --which is described by -1 or 0 to 6
    if P_LATENCY = -1 or (P_LATENCY >= 0 and P_LATENCY <= ci_max_latency) or
      (P_LATENCY >= 64 and P_LATENCY < 128) then
      if P_LATENCY >= 64 and P_LATENCY < 128 then
        -- gui trans_off
        v_enable_tier := std_logic_vector(to_unsigned(P_LATENCY, 6));
        -- gui trans_on
        -- gui insert_on
        -- v_enable_tier := int_to_slv(P_LATENCY, 6);
        -- gui insert_off
        
        --Will only allocate tiers that are specified to will never have excess latency
        v_latency_left := 0;
      else
        v_latency_left := p_latency;
      end if;
      

      --deal out latency according to generics and architecture for optimal speed
      --and resource
      --preg - first!
      if (v_latency_left /= 0 and P_LATENCY<64) or v_enable_tier(5) = '1' then
        v_latency_left             := v_latency_left-1;
        ret_val.pipe(ci_p6)        := ret_val.pipe(ci_p6) +1;
        ret_val.pipe(ci_carryout6) := ret_val.pipe(ci_carryout6) +1;
        ret_val.used               := ret_val.used +1;
      end if;

      if (v_latency_left /= 0 and P_LATENCY<64) or v_enable_tier(4) = '1' then
        v_latency_left       := v_latency_left-1;
        ret_val.pipe(ci_m5)  := ret_val.pipe(ci_m5) +1;
        ret_val.pipe(ci_op5) := ret_val.pipe(ci_op5) +1;
        ret_val.pipe(ci_c5)  := ret_val.pipe(ci_c5) +1;
        ret_val.pipe(ci_concat5) := ret_val.pipe(ci_concat5) +1;
        ret_val.pipe(ci_carryin5):= ret_val.pipe(ci_carryin5) +1;
        --carryin5? Maybe for non-spartan families
        ret_val.used         := ret_val.used +1;
      end if;

      if (v_latency_left /= 0 and P_LATENCY<64) or v_enable_tier(3) = '1' then
        v_latency_left           := v_latency_left-1;
        ret_val.pipe(ci_op4)     := ret_val.pipe(ci_op4) +1;
        ret_val.pipe(ci_a4)      := ret_val.pipe(ci_a4) +1;
        ret_val.pipe(ci_b4)      := ret_val.pipe(ci_b4) +1;
        ret_val.pipe(ci_c4)      := ret_val.pipe(ci_c4) +1;
        ret_val.pipe(ci_concat4) := ret_val.pipe(ci_concat4) +1;
        ret_val.pipe(ci_carryin4):= ret_val.pipe(ci_carryin4) +1;
        ret_val.used             := ret_val.used +1;
      end if;

      if (v_latency_left /= 0 and P_LATENCY<64) or v_enable_tier(2) = '1' then
        v_latency_left           := v_latency_left-1;
        ret_val.pipe(ci_op3)     := ret_val.pipe(ci_op3) +1;
        ret_val.pipe(ci_a3)      := ret_val.pipe(ci_a3) +1;
        ret_val.pipe(ci_b3)      := ret_val.pipe(ci_b3) +1;
        ret_val.pipe(ci_c3)      := ret_val.pipe(ci_c3) +1;
        ret_val.pipe(ci_d3)      := ret_val.pipe(ci_d3) +1;
        ret_val.pipe(ci_carryin3):= ret_val.pipe(ci_carryin3) +1;
        ret_val.used             := ret_val.used +1;
      end if;

      if (v_latency_left /= 0 and P_LATENCY<64 and v_macro_config.use_premux) or v_enable_tier(1) = '1' then
        v_latency_left       := v_latency_left-1;
        ret_val.pipe(ci_op2) := ret_val.pipe(ci_op2) +1;
        if P_HAS_ACIN=0 then
          --Fabric stage not supported with cascade input
          ret_val.pipe(ci_a2)  := ret_val.pipe(ci_a2) +1;
        end if;
        if P_HAS_BCIN=0 then
          ret_val.pipe(ci_b2)  := ret_val.pipe(ci_b2) +1;
        end if;
        ret_val.pipe(ci_c2)  := ret_val.pipe(ci_c2) +1;
        ret_val.pipe(ci_d2)  := ret_val.pipe(ci_d2) +1;
        ret_val.pipe(ci_carryin2):= ret_val.pipe(ci_carryin2) +1;
        ret_val.used         := ret_val.used +1;
      end if;

      if (v_latency_left /= 0 and P_LATENCY<64 and v_macro_config.use_premux) or v_enable_tier(0) = '1' then
        v_latency_left       := v_latency_left-1;
        ret_val.pipe(ci_op1) := ret_val.pipe(ci_op1) +1;
        if P_HAS_ACIN=0 then
          ret_val.pipe(ci_a1)  := ret_val.pipe(ci_a1) +1;
        end if;
        if P_HAS_BCIN=0 then
          ret_val.pipe(ci_b1)  := ret_val.pipe(ci_b1) +1;
        end if;
        ret_val.pipe(ci_c1)  := ret_val.pipe(ci_c1) +1;
        ret_val.pipe(ci_d1)  := ret_val.pipe(ci_d1) +1;
        ret_val.pipe(ci_carryin1):= ret_val.pipe(ci_carryin1) +1;
        ret_val.used         := ret_val.used +1;
      end if;


      --report excess latency.
      if v_latency_left > 0 then
        assert false
          report "ERROR: excess latency in xbip_dsp48_macro"
          severity error;
      end if;

      assert (p_verbosity < 2)
        report "used = "&integer'image(ret_val.used)
        severity note;
    end if;
    if P_LATENCY >= 128 then            --expert mode.
      for i in 1 to ci_num_registers loop
        if P_REG_CONFIG(i) = '1' then
          ret_val.pipe(i) := 1;
        end if;
      end loop;  -- i in 1 to ci_num_registers
    end if;
    
    --Resolve Spartan3ADSP/6 carryin and opmode register enabling
    --  - this is required to ensure that carryin from fabric is not double registered
    if supports_dsp48a(P_XDEVICEFAMILY) > 0 then
      if P_SEL_WIDTH=0 then
        --Does not need to be set when constant opcode
        ret_val.pipe(ci_op5) := 0;
      end if;
      if ret_val.pipe(ci_op5) = 1 and ret_val.pipe(ci_carryin5) = 1 and P_HAS_CARRYIN=1 then
        -- Disable carryin reg to avoid double registering
        ret_val.pipe(ci_carryin5):=0;
      end if;
      if ret_val.pipe(ci_carryin5) = 1 and P_HAS_CARRYCASCIN=1 then
        -- On spartan ci_carryin5 can set a reg on the carryin(carrycascin) path. This is in consistent with Virtex and
        -- cannot be indicated on the GUI so disable
        ret_val.pipe(ci_carryin5):=0;
      end if;
      if ret_val.pipe(ci_op5) = 1 and P_HAS_D = 1 then
        -- when the preadder is used these registers can not be seperated
        ret_val.pipe(ci_op3) := 1;
        -- set whole tier if auto or tiered
        if P_LATENCY < 128 then
          ret_val.pipe(ci_a3)      := 1;
          ret_val.pipe(ci_b3)      := 1;
          ret_val.pipe(ci_c3)      := 1;
          ret_val.pipe(ci_d3)      := 1;
          ret_val.pipe(ci_carryin3):= 1;
        end if;
      end if;
    end if;

    --populate the registers selected into the reg_config return value
    ret_val.reg_config:=ret_val.pipe;
    
    --When Spartan3ADSP/6 update ci_carryin5 value when ci_op5 is set
    --    - the carryin path is considered seperate and ci_carryin5 should be
    --      shown to be set. ci_carryin5 and ci_op5 are tied.
    if supports_dsp48a(P_XDEVICEFAMILY) > 0 then
      if ret_val.pipe(ci_op5) = 1 and P_HAS_CARRYIN=1 then
        ret_val.reg_config(ci_carryin5) := 1;
      end if;
    end if;
    
    --Produce string equivalent for debug output
    if p_verbosity>=2 then
      for w in 1 to ci_num_registers loop
        if ret_val.reg_config(w) = 1 then
          v_reg_config(w) := '1';
        else
          v_reg_config(w) := '0';
        end if;
      end loop;  -- w
      report "Reg config = "&v_reg_config
      severity note;
    end if;
    
    return ret_val;
    
  end function fn_dsp48_macro_v2_0_latency;

  --the rounding constant is 0.49999 where the binary point is determined by
  --the width of P, hence for width of 2, the constant would be 00.0111111
  -- function fn_get_round_const (
    -- p_p_width : integer
    -- )
    -- return std_logic_vector is
    -- variable ret_val : std_logic_vector(ci_dsp48_c_width-1 downto 0) := (others => '0');
  -- begin
    -- ret_val := (others => '0');
    -- if p_p_width+2 > ci_dsp48_p_width then
      -- return ret_val;
    -- end if;
    -- ret_val(ci_dsp48_p_width -(p_p_width+1)-1 downto 0) := (others => '1');
    -- return ret_val;
  -- end function fn_get_round_const;
  function fn_get_round_const (
    p_p_lsb : integer
    )
    return std_logic_vector is
    variable ret_val : std_logic_vector(ci_dsp48_c_width-1 downto 0) := (others => '0');
  begin
    ret_val := (others => '0');
    if p_p_lsb < 2 then
      return ret_val;
    end if;
    ret_val(p_p_lsb-2 downto 0):=(others=>'1');
    return ret_val;
  end function fn_get_round_const;

  function fn_get_macro_config (
    pOPMODE : string)
    return t_macro_config is
    variable v_val          : string(1 to pOPMODE'length);
    -- variable temp_str       : string(1 to pOPMODE'length);
    -- variable clear_str      : string(1 to pOPMODE'length);
    variable temp_str       : string(1 to ci_opmode_width);
    variable clear_str      : string(1 to ci_opmode_width);
    variable opmode         : std_logic_vector(ci_opmode_width-1 downto 0);
    variable len            : integer;
    variable v_uses_cascade : boolean;
    variable v_uses_mult    : boolean;
    variable v_use_premux   : boolean;
    variable v_use_round    : boolean;
    variable start          : integer;
    variable addr           : integer;
    variable cursor         : integer;
    variable ret_val        : t_macro_config;
  begin
    v_val          := pOPMODE;
    len            := v_val'LENGTH;
    ret_val.use_cascade := false;
    ret_val.use_mult    := false;
    ret_val.use_premux  := false;
    ret_val.use_round   := false;
    ret_val.num_opmodes := 0;

    --find the first non-space character
    start := 0;
    for i in 1 to len loop
      if v_val(i) = '0' or v_val(i) = '1' then
        start := i;
        exit;
      end if;
    end loop;  -- i
   
    if start = 0 then
      assert false
        report "ERROR: xbip_dsp48_macro_v2_0: no 0/1's detected in OPMODE string"
        severity ERROR;
      --assert false report "OPMODE = "&pOPMODE severity note;
      return ret_val;                       --return default  invalid
    end if;
    
    -- gui trans_off
    for w in temp_str'range loop
      clear_str(w) := '0';              --used to clear temp_str
    end loop;
    -- gui trans_on
    -- gui insert_on
    -- clear_str := slv_to_str(int_to_slv(0,ci_opmode_width));
    -- gui insert_off

    temp_str := clear_str;
    addr := 0;
    cursor := 0;

    --will this loop detect the last opmode? &&&
    for j in start to len loop
      if v_val(j) = '1' or v_val(j) = '0' then
        cursor := cursor +1;            --keep track of its length
        
        if cursor > ci_opmode_width then -- check current opcode is not too big
          report "ERROR: xbip_dsp48_macro_v2_0(fn_get_macro_config): opmode string ("&pOPMODE&") contains opmode containing "
                  &integer'image(cursor)&" characters, expecting "&integer'image(ci_opmode_width) severity error;
          return ret_val;
        end if;
        
        temp_str(cursor) := v_val(j);   --construct element string
      else
        
        if cursor < ci_opmode_width then -- check current opcode is not too small
          report "ERROR: xbip_dsp48_macro_v2_0(fn_get_macro_config): opmode string ("&pOPMODE&") contains opmode containing "
                  &integer'image(cursor)&" characters, expecting "&integer'image(ci_opmode_width) severity error;
          return ret_val;
        end if;
        
        ret_val.num_opmodes := ret_val.num_opmodes +1;
        --next word
        -- opmode := str_to_bound_slv_0(str_to_bound_str(temp_str(1 to cursor),ci_opmode_width,"0"),ci_opmode_width);
        opmode := str_to_bound_slv_0(temp_str,ci_opmode_width);
        temp_str := clear_str;
        cursor := 0;
        addr := addr+1;
        -- gui trans_off
        if opmode(ti_opfield_xmux) = "01" then
          ret_val.use_mult := true;
        end if;
        if opmode(ti_opfield_xmux) = "11" then
          ret_val.use_cascade := true;
        end if;
        -- gui trans_on
        -- gui insert_on
        -- if opmode(ci_opfield_xmux_1) = '0' and opmode(ci_opfield_xmux_0) = '1' then
          -- ret_val.use_mult := true;
        -- end if;
        -- if opmode(ci_opfield_xmux_1) = '1' and opmode(ci_opfield_xmux_0) = '1' then
          -- ret_val.use_cascade := true;
        -- end if;
        -- gui insert_off
        if opmode(ci_opfield_cmux) = '1' then
          ret_val.use_round := true;
        end if;
        if opmode(ci_opfield_abmux) = '1' then
          ret_val.use_premux := true;
        end if;
      end if;
      if j = len and (v_val(j) = '1' or v_val(j) = '0') then
        
        if cursor < ci_opmode_width then -- check current opcode is not too small
          report "ERROR: xbip_dsp48_macro_v2_0(fn_get_macro_config): opmode string ("&pOPMODE&") contains opmode containing "
                  &integer'image(cursor)&" characters, expecting "&integer'image(ci_opmode_width) severity error;
          return ret_val;
        end if;
        
        ret_val.num_opmodes := ret_val.num_opmodes +1;
        --next word
        -- opmode := str_to_bound_slv_0(str_to_bound_str(temp_str(1 to cursor),ci_opmode_width,"0"),ci_opmode_width);
        opmode := str_to_bound_slv_0(temp_str,ci_opmode_width);
        temp_str := clear_str;
        cursor := 0;
        addr := addr+1;
        -- gui trans_off
        if opmode(ti_opfield_xmux) = "01" then
          ret_val.use_mult := true;
        end if;
        if opmode(ti_opfield_xmux) = "11" then
          ret_val.use_cascade := true;
        end if;
        -- gui trans_on
        -- gui insert_on
        -- if opmode(ci_opfield_xmux_1) = '0' and opmode(ci_opfield_xmux_0) = '1' then
          -- ret_val.use_mult := true;
        -- end if;
        -- if opmode(ci_opfield_xmux_1) = '1' and opmode(ci_opfield_xmux_0) = '1' then
          -- ret_val.use_cascade := true;
        -- end if;
        -- gui insert_off
        if opmode(ci_opfield_cmux) = '1' then
          ret_val.use_round := true;
        end if;
        if opmode(ci_opfield_abmux) = '1' then
          ret_val.use_premux := true;
        end if;        
      end if;
    end loop;  -- j
    
    return ret_val;
  end function fn_get_macro_config;
  
  function fn_interpret_opmode (
    opmode : std_logic_vector(ci_opmode_width-1 downto 0)
    )
    return t_opmode_type is
    variable ret_val : t_opmode_type;
    variable temp : string(1 to 37);
  begin
    temp(1 to 6) := " P <= ";
    case opmode(ti_opfield_zmux) is
      when "000"  => temp(7 to 13) := "0      ";
      when "001"  => temp(7 to 13) := "PCIN   ";
      when "010"  => temp(7 to 13) := "P      ";
      when "011"  => temp(7 to 13) := "C      ";
      when "100"  => temp(7 to 13) := "sh PCIN";
      when "101"  => temp(7 to 13) := "sh P   ";
      when "110"  => temp(7 to 13) := "0      ";
      when "111"  => temp(7 to 13) := "0      ";
      when others => temp(7 to 13) := "?      ";
    end case;

    if opmode(ci_opfield_subtract) = '1' then
      temp(14 to 18) := " -  (";
    else
      temp(14 to 18) := " +  (";
    end if;

    case opmode(ti_opfield_ymux) is
      when "00" => temp(19 to 22) := "    ";
      when "01" => temp(19 to 22) := "    ";
      when "10" => temp(19 to 22) := "    ";
      when "11" => temp(19 to 22) := "C + ";
      when others => null;
    end case;
                  
    case opmode(ti_opfield_xmux) is
      when "00" => temp(23 to 25) := "0  ";
      when "01" => temp(23 to 25) := "A*B";
      when "10" => temp(23 to 25) := "P  ";
      when "11" => temp(23 to 25) := "A:B";
      when others => null;
    end case;

    temp(26 to 37) := " + CARRYIN )";
    ret_val.disassembled(1 to 37) := temp;
    return ret_val;
  end function fn_interpret_opmode;
  
  function fn_select_int ( in1, in2 : integer; sel:boolean ) return integer is
  begin
    if sel then
      return in1;
    else
      return in2;
    end if;
  end function fn_select_int;
end package body bip_dsp48_macro_pkg_v2_0;
